/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.action;

import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;

import jp.mosp.kintai.dto.MScheduleDto;
import jp.mosp.kintai.dto.MSyukkinboDto;
import jp.mosp.kintai.vo.ScheduleEditCardVo;

public class ScheduleEditCardAction extends AttendanceTotalAction {

	// R}h
	private static final String CMD_EDIT_CARD_SHOW		= "K1240";
	private static final String CMD_EDIT_CARD_SEARCH		= "K1242";
	private static final String CMD_EDIT_CARD_REGIST		= "K1244";

	/**
	 * RXgN^
	 */
	public ScheduleEditCardAction() {
		super();
	}

	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾
		ScheduleEditCardVo vo;
		vo = (ScheduleEditCardVo)getStoredVo(CommonConst.VO_SCHEDULE_EDIT_CARD);
		if (vo == null) {
			vo = new ScheduleEditCardVo();
		}
		vo.initVo(cfg, msg, cmd, aspUser, user);
		vo.clearMessage();
		vo.clearErrField();
		storeVo(CommonConst.VO_SCHEDULE_EDIT_CARD, vo);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		// DBRlNV擾
		getConnection();
		// [U[擾
		getInfo(user.getUserId());
		// \
		Date current = util.getSystemDate();
		// v_E擾
		vo.aryPltYear  = util.getYearArray(MospUtility.getYear (current), 2, 1);
		vo.aryPltMonth = util.getMonthArray();
		vo.aryPltWorkType = util.addArrayFirstRowSpace(getWorkTypeArrayWithWeekHoliday());
		// ΏێЈݒ
		vo.setSelectKCode(mKihon.getKCode());
		// bZ[W\
		setMessage(vo);
		// R}h̏
		if (cmd.equals(CMD_EDIT_CARD_SHOW)) {
			// \
			// Ώ۔Nݒ
			vo.setPltYear(String.valueOf(MospUtility.getYear(current)));
			vo.setPltMonth(String.valueOf(MospUtility.getMonth(current)));
			// 
			searchScheduleList(vo);	
		} else if (cmd.equals(CMD_EDIT_CARD_SEARCH)) {
			// Ώ۔Nݒ
			vo.setParams(request);
			// 
			searchScheduleList(vo);		
		} else if (cmd.equals(CMD_EDIT_CARD_REGIST)) {
			// p[^ݒ
			vo.setParams(request);
			// o^i擾j
			int number = regist(vo);
			// R~bg
			commit();
			// \mF֑J
			setNextCmd(ScheduleConfirmListAction.CMD_CONFIRM_LIST_SEARCH);
			// bZ[Wݒ
			request.setAttribute(MospConst.ATT_MESSAGE, 
					MospUtility.getMessage(msg,	CommonConst.MSG_NUMBER_OF_UPDATES, String.valueOf(number))
			);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	/**
	 * \ꗗ
	 * @param vo VoCX^X
	 * @throws Exception
	 */
	private void searchScheduleList(
			ScheduleEditCardVo vo
	) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// ΑӃf[^擾
		//getScheduleList(vo.getSelectKCode(), vo.getPltYear(), vo.getPltMonth());
		/*						
		 *  	2009/01/20	m.yoshida	ߓΉ
		 */
		//getScheduleList(vo.getSelectKCode(), utility.getYearMonth(vo.getPltYear(), vo.getPltMonth()));
		getScheduleListForView(vo.getSelectKCode(), util.getYearMonth(vo.getPltYear(), vo.getPltMonth()));
		// Wvf[^Ԑݒ
		setScheduleHours();
		// Wvf[^z쐬
		makeScheduleArray();
		// l{̐ݒ
		setSelectBasicInfo(vo);
		// VOݒ
		vo.setFields(aryAttendance);
	}

	/**
	 * Wvf[^z쐬
	 * @throws Exception
	 */
	private void makeScheduleArray() throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// f[^擾
		Calendar cal = Calendar.getInstance();
		cal.setTime(MospUtility.getDate(startDate));
		int count = 0;
		while (MospUtility.getDate(endDate).compareTo(cal.getTime()) >= 0) {
			cal.add(Calendar.DAY_OF_MONTH, 1);
			count++;
		}
		// z񏉊
		aryAttendance = new String[count][40];
		for (int i = 0; i < aryAttendance.length; i++) {
			for (int j = 0; j < aryAttendance[i].length; j++) {
				aryAttendance[i][j] = "";
			}
		}
		// tݒ
		cal.setTime(MospUtility.getDate(startDate));
		for (int i = 0; i < aryAttendance.length; i++) {
			// t
			aryAttendance[i][0] = String.valueOf(MospUtility.getMonth(cal.getTime()))
			+ CommonConst.SEPARATOR_DATE
			+ String.valueOf(cal.get(Calendar.DAY_OF_MONTH));
			// j
			aryAttendance[i][1] = getDayOfWeek(cal.get(Calendar.DAY_OF_WEEK));
			// lijՓAxj
			StringBuffer remark = new StringBuffer();
			String holidayName = getPublicHolidayName(cal.getTime());
			if (holidayName.length() != 0) {
				remark.append(holidayName);
				remark.append(CommonConst.NAM_COMMON_HALF_KANA_SPACE);
			}
			aryAttendance[i][8] = remark.toString();
			cal.add(Calendar.DAY_OF_MONTH, 1);
		}
		// f[^̐ݒ
		Iterator<MScheduleDto> it = scheduleList.iterator();
		while (it.hasNext()) {
			cal.setTime(MospUtility.getDate(startDate));
			MScheduleDto dto = it.next();
			Date scheduleDate = MospUtility.getDate(dto.getHizuke());
			for (int i = 0; i < aryAttendance.length; i++) {
				if (scheduleDate.compareTo(cal.getTime()) == 0) {
					// Ζ`
					String kinmu = "";
					if (isAvailableWorkType(dto)) {
						kinmu = workTypeMap.get(dto.getKinmu()).getShiftName();
						// Ζ`ԃR[h
						aryAttendance[i][3] = workTypeMap.get(dto.getKinmu()).getShiftCode();						
						// oΎ
						aryAttendance[i][4] = dto.getSyJikoku();
						// ދΎ
						aryAttendance[i][5] = dto.getTaJikoku();
						// Ζ
						aryAttendance[i][6] = getHourString(util.convIntegerTimeToDoubleTime(dto.getKinmuJi()));
						// xe
						aryAttendance[i][7] = getHourString(util.convIntegerTimeToDoubleTime(dto.getKyukeiJi()));
					} else if (isWeekHoliday(dto)) {
						// Tx̏ꍇ
						kinmu = CommonConst.ATTENDANCE_TYPE_WEEK_HOLIDAY;
						aryAttendance[i][3] = kinmu;
					} else {
						for (int k = 0; k < aryHolidayReason.length; k++) {
							if (aryHolidayReason[k][0].equals(dto.getKKRiyuu())) {
								kinmu = aryHolidayReason[k][1];
							}
						}
					}
					aryAttendance[i][2] = kinmu;
					break;
				}
				cal.add(Calendar.DAY_OF_MONTH, 1);
			}
		}
	}

	/**
	 * o^
	 * @param vo
	 * @return	number
	 * @throws SQLException 
	 * @throws ClassNotFoundException 
	 */
	private int regist(ScheduleEditCardVo vo) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// p[^̑ÓmF
		vo.validate();
		// J_[̌Ăяo
		Calendar cal = Calendar.getInstance();
		// Ώ۔N擾
		Date targetMonth = util.getYearMonth(vo.getPltYear(), vo.getPltMonth());
		// oΕ̎擾Ə
		/*						
		 *  	2009/01/20	m.yoshida	ߓΉ
		 */
		getAttendanceListForView(vo.getSelectKCode(), targetMonth);
		// oΕWvf[^Ԑݒ
		setHours();
		// zɓtƋΖ`ԃR[hZbg
		String[][] aryNewScheduleList = makeNewScheduleList(vo, targetMonth);
		// XVEo^
		int number = 0;
		// oἘt̎擾
		Date[] attendanceDate = null ;
		if (attendanceList.size() != 0) {
			attendanceDate = new Date[attendanceList.size()];
			for (int k = 0; k < attendanceList.size(); k++) {
				attendanceDate[k] = MospUtility.getDate(attendanceList.get(k).getHizuke());
			}
		}
		// XPW[o^
		for (int i = 0; i < aryNewScheduleList.length; i++) {
			if (aryNewScheduleList[i][1].equals("")) {
				// Ζ`Ԃ󗓂ȂΏۓ̗\폜
				if (!delete(getScheduleInfo(mKihon.getKCode(), aryNewScheduleList[i][0]))) {
					number++;
				}
				continue;
			}
			// Ζ`ԂftHg̒l擾A\DTOɃZbg
			MScheduleDto registScheduleDto = setScheduleInfo(
					mKihon.getKCode(),
					mKihon.getSCode(),
					aryNewScheduleList[i]);
			// XPW[̓t擾
			cal.setTime(MospUtility.getDate(aryNewScheduleList[i][0]));
			// toΕ
			if (chkExistObject(attendanceDate)) {
				// oΊmF
				boolean isAttendance = false;
				for (int m = 0; m < attendanceDate.length; m++) {
					if (attendanceDate[m].compareTo(cal.getTime()) == 0) {
						isAttendance = true;
						break;
					}
				}
				if (isAttendance) {
					// oΕɊɓo^Ăꍇ͗\̂ݍXV
					registSchedule(registScheduleDto, vo);
					number++;
				} else {
					// oΕƗ\\ɓlo^
					MSyukkinboDto insertSyukkinboDto = copyScheduleInfo(registScheduleDto);
					// oΕɓo^
					insert(insertSyukkinboDto, vo);
					// \ɓo^
					registSchedule(registScheduleDto, vo);
					number++;
				}
			} else {
				// oΕ냊Xgꍇ
				// oΕƗ\\ɓlo^
				MSyukkinboDto insertSyukkinboDto = copyScheduleInfo(registScheduleDto);
				// oΕɓo^
				insert(insertSyukkinboDto, vo);
				// \ɓo^
				registSchedule(registScheduleDto, vo);
				number++;
			}
		}
		// Zbg		
		return number;
	}

	/**
	 * XPW[z
	 * @param vo ΏVO
	 * @param targetMonth Ώی
	 * @return VK\pz
	 * @throws Exception
	 */
	private String[][] makeNewScheduleList(ScheduleEditCardVo vo, Date targetMonth) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		/*						
		 *  	2009/01/20	m.yoshida	ߓΉ
		 */
		//Date startDate 	= getStartDate(targetMonth);
		//Date endDate 	= getEndDate(targetMonth);
		Date startDate 	= getStartDateForList(targetMonth);
		Date endDate 	= getEndDateForList(targetMonth);
		// f[^擾
		Calendar cal = Calendar.getInstance();
		cal.setTime(startDate);
		// ̐ݒ
		int count = 0;
		while (endDate.compareTo(cal.getTime()) >= 0) {
			cal.add(Calendar.DAY_OF_MONTH, 1);
			count++;
		}
		// z̏
		String[][] arySchedule = new String[count][2];
		for (int i = 0; i < arySchedule.length; i++) {
			arySchedule[i][0] = "";
			arySchedule[i][1] = "";
		}
		// tݒ
		cal.setTime(startDate);
		for (int i = 0; i < arySchedule.length; i++) {
			// t
			arySchedule[i][0] = MospUtility.getDateString(cal.getTime(), CommonConst.FORMAT_DATE);
			arySchedule[i][1] = vo.getArySelectWorktype()[i];
			cal.add(Calendar.DAY_OF_MONTH, 1);
		}
		return arySchedule;
	}

	/**
	 * \̍폜
	 * @param dto
	 * @throws Exception
	 */
	private boolean delete(MScheduleDto dto) throws Exception {
		// \pDAO 
		prepareMScheduleDao();
		if (dto == null) {
			return true;
		}
		// ݃`FbN
		chkExist(getScheduleInfo(dto.getKCode(), dto.getHizuke()));
		// f[^̍폜
		scheduleDao.delete(dto);
		return chkExistDto(getScheduleInfo(dto.getKCode(), dto.getHizuke()));
	}

	/**
	 * bZ[W̃Zbg
	 * @param vo
	 * @throws Exception
	 */
	private void setMessage(ScheduleEditCardVo vo) throws Exception {
		// \납폜@bZ[WɃZbgB
		vo.setMessage(CommonConst.MSG_SCHEDULE_EDIT_METHODS);
	}

}
